rule ByteCode_MSIL_Ransomware_Ghostbin : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "GHOSTBIN"
        description         = "Yara rule that detects Ghostbin ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Ghostbin"
        tc_detection_factor = 5

    strings:

        $setup_env = {
            7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A 16 0B 2B ?? 06 07 9A 0C
            08 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 16 18 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 16
            28 ?? ?? ?? ?? 2C ?? 08 6F ?? ?? ?? ?? 19 FE 01 08 6F ?? ?? ?? ?? 18 FE 01 60 2C ?? 08
            6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 07 17 D6 0B 07 06 8E 69 32 ?? 00 72 ?? ?? ?? ?? 28 ?? ??
            ?? ?? 2C ?? 16 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ??
            ?? DE ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? DE ?? 00 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 2C ?? 72
            ?? ?? ?? ?? 72 ?? ?? ?? ?? 16 1F ?? 16 28 ?? ?? ?? ?? 26 DE ?? 28 ?? ?? ?? ?? 28 ?? ??
            ?? ?? DE ?? 2A
        }

        $encrypt_files = {
            73 ?? ?? ?? ?? 73 ?? ?? ?? ?? 0A 25 6F ?? ?? ?? ?? 25 06 28 ?? ?? ?? ?? 03 6F ?? ?? ??
            ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 25 17 6F ?? ?? ?? ?? 25 6F ?? ?? ?? ?? 0C 6F ?? ?? ??
            ?? 02 16 02 8E 69 6F ?? ?? ?? ?? 0B 07 8E 69 17 59 1F ?? 58 17 58 8D ?? ?? ?? ?? 0D 08
            09 1F ?? 28 ?? ?? ?? ?? 07 16 09 1F ?? 07 8E 69 28 ?? ?? ?? ?? 09 2A
        }

        $find_files = {
            02 17 8D ?? ?? ?? ?? 25 16 1F ?? 9D 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 16 6F ?? ?? ?? ?? 28
            ?? ?? ?? ?? 72 ?? ?? ?? ?? 16 28 ?? ?? ?? ?? 39 ?? ?? ?? ?? 02 28 ?? ?? ?? ?? 0A 16 0B
            2B ?? 06 07 9A 0C 7E ?? ?? ?? ?? 08 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2C ?? 08 28 ?? ?? ??
            ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 08 7E ?? ?? ?? ?? 28 ?? ?? ?? ??
            28 ?? ?? ?? ?? 08 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 08 28 ??
            ?? ?? ?? 08 28 ?? ?? ?? ?? DE ?? 25 28 ?? ?? ?? ?? 0D 28 ?? ?? ?? ?? DE ?? 07 17 D6 0B
            07 06 8E 69 32 ?? 02 28 ?? ?? ?? ?? 13 ?? 16 13 ?? 2B ?? 11 ?? 11 ?? 9A 28 ?? ?? ?? ??
            11 ?? 17 D6 13 ?? 11 ?? 11 ?? 8E 69 32 ?? DE ?? 25 28 ?? ?? ?? ?? 13 ?? 28 ?? ?? ?? ??
            DE ?? 2A
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $setup_env
        ) and
        (
            $find_files
        ) and
        (
            $encrypt_files
        )
}